<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Consalty_Core;
extract($data);

if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);

$swiper_data = json_encode( $swiper_data );
$thumb_size=''
?>

<div class="video-slider  video-<?php echo esc_attr( $data['style'] );?>">
    <div class="rt-related-slider video-gallery-slider" dir="rtl" data-xld = '<?php echo esc_attr( $swiper_data )  ;?>'>
        <div class="swiper-wrapper">
            <?php foreach ( $data['videos'] as $video ): 
                ?>
                
                <div class="swiper-slide">
                    <div class="rtin-video">
                            
                            <?php if($video['image']['id']){
                                echo wp_get_attachment_image( $video['image']['id'],$thumb_size);
                            }
                            ?>
                            <?php if($video['video_slider_url']['url']): ?>
                                <div class="video-content">
                                    <a href="<?php echo esc_url($video['video_slider_url']['url'] );?>" class="play-btn play-btn-big rt-video-popup">
                                        <span class="play-icon style-1">
                                            <i class="fas fa-play"></i>
                                        </span>
                                    </a>
                                </div>
                            <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php if($data['navigation']=='yes'){ ?>
        <div class="swiper-pagination"></div>
        <?php } ?>
    </div>
</div>
