<?php
/**
 * 
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;
extract( $data );

?>
<div class="rt-fin-pricing-wrap position-relative section-padding">
 
    <div class="pricing-tab-switch">
        <div class="tab-list">
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" data-bs-target="#month" href="#month"><?php echo esc_html($data['monthly_label'] ); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#year" href="#year" ><?php echo esc_html($data['yearly_label'] ); ?></a>
                </li>
            </ul>
            <span class="save-tag"><span class="text"><?php echo esc_html($data['save_upto'] ); ?></span></span>
        </div>
    </div>
    <div class="tab--style--1">
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="month" role="tabpanel">
                <div class="row justify-content-center">
                    <?php if(!empty($data['prices_infos'])){ 
                        foreach($data['prices_infos'] as $index=>$price_info){
                    ?>
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="fin-price-box">
                            <?php if(!empty($price_info['most_popular'])){?>
                                <div class="badge"><?php echo wp_kses_post($price_info['most_popular']); ?></div>
                            <?php } ?>

                            <?php if ( 'yes' === $data['right_icon'] ) { ?>
                            <div class="shape">
                                <svg width="49" height="75" viewBox="0 0 49 75" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g opacity="0.3">
                                    <path opacity="0.5" d="M3.43262 74.979L3.43262 51.6416L19.2197 63.3103L3.43262 74.979Z" fill="currentColor"/>
                                    <path opacity="0.44" d="M48.734 72.9199L48.734 0.162112L26.2055 16.9783L-1.59244e-06 36.5928L48.734 72.9199Z" fill="currentColor"/>
                                    </g>
                                </svg>
                            </div>
                            <?php } ?>


                            <?php if ( !empty($price_info['top_icon']) ) { ?>
                                <div class="price-shape mb-4">
                                    <?php Icons_Manager::render_icon( $price_info['top_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                            <?php } ?>

                           
                            <?php if(!empty($price_info['title'])){?>
                            <div class="label"><?php echo wp_kses_post($price_info['title']); ?></div>
                            <?php } ?>
                            <?php if(!empty($price_info['content'])){?>
                                <p class="mb-4">
                                <?php echo wp_kses_post($price_info['content']); ?>
                                </p>
                            <?php } ?>

                            <?php if($price_info['monthly_price']){ ?>
                                <div class="price-box mb-4 price-box-show">
                                    <div class="pricing__price">
                                        <?php echo wp_kses_post($price_info['monthly_price']); ?> <sub>/<?php echo esc_html('Month', 'finbuzz'); ?></sub>
                                    </div>
                                </div>
                            <?php } ?>
                            
                            <?php if($price_info['list_item']){ ?>
                                <div class="list-pricing">
                                    <?php echo wp_kses_post($price_info['list_item']); ?>
                                </div>
                            <?php } ?>
                            
                            <?php if(!empty($price_info['btn_text'])){?>
                            <div class="pricing-button">
                                <a href="<?php if($price_info['btn_link']['url']){ echo $price_info['btn_link']['url']; } ?>" class="pricing-btn"><?php echo wp_kses_post($price_info['btn_text']); ?></a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php } } ?> 
                </div>
            </div>
            <div class="tab-pane fade show" id="year" role="tabpanel">
                <div class="row justify-content-center">

                    <?php if(!empty($data['prices_infos'])){ 
                        foreach($data['prices_infos'] as $index=>$price_info){
                    ?>

                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="fin-price-box">
                            <?php if(!empty($price_info['most_popular'])){?>
                            <div class="badge"><?php echo wp_kses_post($price_info['most_popular']); ?></div>
                            <?php } ?>
                            <?php if ( 'yes' === $data['right_icon'] ) { ?>
                            <div class="shape">
                                <svg width="49" height="75" viewBox="0 0 49 75" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g opacity="0.3">
                                    <path opacity="0.5" d="M3.43262 74.979L3.43262 51.6416L19.2197 63.3103L3.43262 74.979Z" fill="currentColor"/>
                                    <path opacity="0.44" d="M48.734 72.9199L48.734 0.162112L26.2055 16.9783L-1.59244e-06 36.5928L48.734 72.9199Z" fill="currentColor"/>
                                    </g>
                                </svg>
                            </div>
                            <?php } ?>
                            <?php if ( !empty($price_info['top_icon']) ) { ?>
                                <div class="price-shape mb-4">
                                    <?php Icons_Manager::render_icon( $price_info['top_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                            <?php } ?>
                            <?php if(!empty($price_info['title'])){?>
                            <div class="label"><?php echo wp_kses_post($price_info['title']); ?></div>
                            <?php } ?>
                            <?php if(!empty($price_info['content'])){?>
                                <p class="mb-4">
                                <?php echo wp_kses_post($price_info['content']); ?>
                                </p>
                            <?php } ?>
                            <?php if($price_info['yearly_price']){ ?>
                                <div class="price-box mb-4 price-box-show">
                                    <div class="pricing__price">
                                        <?php echo wp_kses_post($price_info['yearly_price']); ?> <sub>/<?php echo esc_html('Yearly', 'finbuzz'); ?></sub>
                                    </div>
                                </div>
                            <?php } ?>
                            
                            <?php if($price_info['list_item']){ ?>
                                <div class="list-pricing">
                                    <?php echo wp_kses_post($price_info['list_item']); ?>
                                </div>
                            <?php } ?>
                            
                            <?php if(!empty($price_info['btn_text'])){?>
                            <div class="pricing-button">
                                <a href="<?php if($price_info['btn_link']['url']){ echo $price_info['btn_link']['url']; } ?>" class="pricing-btn"><?php echo wp_kses_post($price_info['btn_text']); ?></a>
                            </div>
                            <?php } ?>

                        </div>
                    </div>
                    <?php } } ?> 

                </div>
            </div>
        </div>
    </div>

</div>






