<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme;
use FinbuzzTheme_Helper;
extract( $data );
$attr = '';
if ( !empty( $data['button_url']['url'] ) ) {
	$attr  = 'href="' . $data['button_url']['url'] . '"';
	$attr .= !empty( $data['button_url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['button_url']['nofollow'] ) ? ' rel="nofollow"' : '';
}

if ( !empty( $data['button_text'] ) ) {
	$btn = '<a class="btn-style1" ' . $attr . '>' . $data['button_text'] .'</a>';
}
?>

<div class="pricing-plan">
  <div class="pricing-box">
    <div class="background-image">
        <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure93.png'; ?>" width="252" height="155" alt="figure">
    </div>  
    <h3 class="pricing-title"><?php echo esc_html( $package_name ); ?></h3>
    <p><?php echo wp_kses_post( $data['package_text'] ); ?></p>
    <div class="price_and_currency">
       <div class="price-details">
            <div class="price">
                <span class="currency"><?php echo esc_html( $currency_icon ); ?></span><?php echo esc_html($price); ?><span class="unit"><?php echo esc_html( $unit ); ?></span><span class="duration"><?php echo esc_html( $duration ); ?></span>
            </div>
       </div>
    </div>
    <ul class="pricing-features">
      <?php foreach ($features as $feature): ?>
        <li>
          <span class="pricing-features-text">
           <i class="fas fa-circle"></i><?php echo esc_html( $feature['text'] ); ?>
          </span>
        </li>
      <?php endforeach ?>
    </ul>
    <div class="pricing-btn">
        <?php echo wp_kses_post( $btn ); ?>
    </div>
  </div>
</div>

