<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size5';
$cat_single_grid = $data['cat_single'];
$excerpt_display=$data['excerpt_display'];
$excerpt_count = $data['excerpt_count'];
$item_space=$data['item_space'];
$port_serial_display=$data['port_ser_display'];
$title_count = $data['title_count'];
$cat_display=$data['cat_display'];
$read_more_btn=$data['view_portfolio_link_btn'];

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";


$portofolio_data =[
    'item'                  => $data['itemnumber'],
    'cat'                   =>$data['cat_single'],
    'col_class'             =>$col_class,
    'excerpt_display'       => $excerpt_display,
    'excerpt_count'         => $excerpt_count,
    'port_serial_dis'       => $port_serial_display,
    'title_count'           => $title_count,
    'cat_display'           => $cat_display,
    'read_more_btn_dis'     => $read_more_btn,
];

$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'posts_per_page' => $data['itemnumber'],
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

$query = new WP_Query( $args );
?>
<div class="portfolio-default portfolio-multi-layout-2 portfolio-<?php echo esc_attr( $data['layout'] );?>">
    <div class="row portfolio-items <?php echo esc_attr( $item_space ); ?>">
        <?php 
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();	
				$id 		        = get_the_ID();
                $portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
                $content 	= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
                $content            = wp_trim_words( $content, $data['excerpt_count'], '' );
                $finbuzz_port_no    = get_post_meta( $id, 'portfolio_serial_num', true );
		?>
        <div class="<?php  echo esc_attr( $col_class ); ?>">
            <div class="rt-fin-case-box">
                <div class="item-img w-100 position-relative overflow-hidden">
                    <a href="<?php the_permalink(); ?>" class="w-100">
                        <?php
                            if ( has_post_thumbnail() ){
                                the_post_thumbnail( $data['portfolio_12_image_size'] );
                            } else {
                                if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
                                    echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
                                } else {
                                    echo '<img class="w-100" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
                                }
                            }
                        ?>
                    </a>
                    <div class="content">
                        <?php if ( $data['cat_display'] ) { 
							$i = 1;
							$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
							if($term_lists){ ?>
							<span class="subtitle d-flex align-items-center mb-0">
								<?php foreach ( $term_lists as $term_list ){ 
								$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
                                <span class="title-bar1"></span>
                                <span class="title-bar2"></span>
							</span>	
						<?php } }?>	
                        <h3 class="title mb-0"><a href="<?php the_permalink(); ?>"><?php echo wp_kses($portfolio_title,'alltext_allow');?></a></h3>
                    </div>
                </div>
            </div>

	    </div>
        <?php } } ?>
   </div>
	
   <?php 
   wp_reset_query();?>
</div>
