<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
extract($data);

//icon

$phone_final_icon_class       = "far fa-comments";
$phone_final_icon_image_url   = '';
if ( is_string( $phone_icon_class['value'] ) && $dynamic_icon_class =  $phone_icon_class['value']  ) {
  $phone_final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $phone_icon_class['value'] ) ) {
	$phone_final_icon_image_url = $phone_icon_class['value']['url'];
}

$email_final_icon_class       = "far fa-envelope";
$email_final_icon_image_url   = '';
if ( is_string( $email_icon_class['value'] ) && $dynamic_icon_class =  $email_icon_class['value']  ) {
  $email_final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $email_icon_class['value'] ) ) {
	$email_final_icon_image_url = $email_icon_class['value']['url'];
}

$image= Group_Control_Image_Size::get_attachment_image_html( $data, 'image_size', 'image' );
if($image){
	$image_class="show-image";
}else{
	$image_class="no-image";
}
?>
<div class="cta-default cta-<?php echo esc_attr( $data['style'] ); ?> <?php echo esc_attr( $image_class); ?>">
	<div class="action-box">
		<?php if($image): ?>
			<div class="action-box-img">
				<?php echo wp_kses_post($image);?>
			</div>
		<?php endif; ?>
		<div class="cta-info">
			<div class="title">
				<h2 class="cta-title"><?php echo wp_kses_post( $data['title'] );?></h2>
			</div>
			<?php if($data['email'] || $data['pho_number']){ ?>
				<div class="cta-contact-box">
					<?php if($data['pho_number']){ ?>
						<div class="cta-contact cta-contact-1">
							<?php if ( $phone_final_icon_image_url ): ?>
								<div class="contact-icon"><img src="<?php echo esc_url( $phone_final_icon_image_url ); ?>" alt="SVG Icon"></div>
							<?php else: ?>
								<div class="contact-icon"><i class="<?php  echo esc_attr( $phone_final_icon_class ); ?>"></i></div>
							<?php endif ?>
							<div class="contact-content">
								<?php if($data['phone_title']) { ?>
									<div class="contact-title"><?php echo wp_kses_post( $data['phone_title'] );?></div>
								<?php } ?>
								<?php if($data['pho_number']){ ?>
									<div class="contact-info"><a href="tel:<?php echo esc_attr( $data['pho_number'] );?>"><?php echo wp_kses_post( $data['pho_number'] );?></a></div>
								<?php }  ?>
							</div>
						</div>
					<?php } ?>
					<?php if($data['email']){ ?>
						<div class="cta-contact cta-contact-2">
							<?php if ( $email_final_icon_image_url ): ?>
								<div class="contact-icon"><img src="<?php echo esc_url( $email_final_icon_image_url ); ?>" alt="SVG Icon"></div>
							<?php else: ?>
								<div class="contact-icon"><i class="<?php  echo esc_attr( $email_final_icon_class ); ?>"></i></div>
							<?php endif ?>
							<div class="contact-content">
								<?php if($data['email_title']){ ?>
									<div class="contact-title"><?php echo wp_kses_post( $data['email_title'] );?></div>
								<?php } ?>
								<?php  if($data['email']) { ?>
									<div class="contact-info"><a href="mailto:<?php echo esc_attr( $data['email'] );?>"><?php echo wp_kses_post( $data['email'] );?></a></div>
								<?php } ?>
							</div>
						</div>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
