<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
extract($data);

$final_icon_class       = " fas fa-thumbs-up";
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}

$attr = '';
if ( empty( $data['buttonurl']['url'] ) ) {
	$data['buttonurl']['url']="#";
}

$attr .= !empty( $data['buttonurl']['is_external'] ) ? ' target="_blank"' : '';
$attr .= !empty( $data['buttonurl']['nofollow'] ) ? ' rel="nofollow"' : '';

?>
<div class="rt-button rt-button-<?php echo esc_attr( $data['style'] ); ?>">
	<?php if( !empty( $data['buttontext'] ) ) { ?>
		<a class="button <?php echo esc_attr( $data['icon_position'] ); ?>" <?php echo esc_attr($attr); ?> href="<?php echo esc_url( $data['buttonurl']['url'] );?>">
            <?php if($data['icon_position'] == 'icon-left') { ?><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i><?php } ?>
            <?php echo esc_html( $data['buttontext'] );?>
            <?php if($data['icon_position'] == 'icon-right') { ?><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i><?php } ?>
      	</a>
	<?php } ?>
</div>