<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);
$attr = '';
$btn2_attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
}
if ( !empty( $data['btn2_url']['url'] ) ) {
	$btn2_attr  = 'href="' . $data['btn2_url']['url'] . '"';
	$btn2_attr .= !empty( $data['btn2_url']['is_external'] ) ? ' target="_blank"' : '';
	$btn2_attr .= !empty( $data['btn2_url']['nofollow'] ) ? ' rel="nofollow"' : '';
}
$svg='<svg width="18" height="5" viewBox="0 0 18 5" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M15 3V5L18 3L15 0V2H0V3H15Z" fill="black"/>
</svg>';

$btn_bg_trans=$data['btn_bg_transparent']=='yes' ? 'btn-transparent':'no-btn-transparent';

$get_img_url=wp_get_attachment_image_url($data['rt_image']['id'], 'full');

//button style
 
if ( !empty( $data['buttontext'] ) ) {
    $btn = '<a class="btn-style9 btn1 button-arrow active" ' . $attr . '>' .  $data['buttontext'] .'<span>'.$svg.'</span>'.'</a>';
}
if ( !empty( $data['buttontext2'] ) ) {
    $btn2 = '<a class="btn-style9 button-arrow" ' . $btn2_attr . '>' .  $data['buttontext2'] .'<span>'.$svg.'</span>'.'</a>';
}

?>  

<!-- Start Banner -->
<section class="banner-addon style-7">
    <div class="banner-content-wrap">
        <div class="image-layout" data-bg-image="<?php echo esc_url($get_img_url); ?>"></div>
        <div class="bg-shape"><img src="<?php echo FINBUZZ_ASSETS_URL . 'img/bg-round.svg'; ?>" alt="bg"></div>
        <div class="row">
            <div class="col-lg-12">
                <div class="banner-content">
                    <div class="subtitle  wow fadeInUp" data-wow-delay="1s" data-wow-duration="1s"><?php echo wp_kses_post($data['sub_title']); ?></div>
                    <h1 class="banner-title wow fadeInUp" data-wow-delay="1.2s" data-wow-duration="1s">
                        <?php echo wp_kses_post( $data['title'] );?>
                    </h1>
                    <p class="wow fadeInUp" data-wow-delay="1.4s" data-wow-duration="1s">
                    <?php echo wp_kses_post( $data['content'] );?>
                    </p>
                    <?php if ( !empty( $data['buttontext'] ) || !empty($data['buttontext2']) ){ ?>
                        <div class="btn-wrap wow fadeInUp <?php echo esc_attr($btn_bg_trans); ?>" data-wow-delay="1.6s" data-wow-duration="1s">
                            <?php if($data['buttontext']) echo wp_kses_post( $btn );?>
                            <?php if($data['buttontext2']) echo wp_kses_post( $btn2 ); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>		
</section>
<!-- End Banner -->
