<?php
$finbuzz_footer_column = FinbuzzTheme::$options['footer_column_3'];
switch ( $finbuzz_footer_column ) {
	case '1':
	$finbuzz_footer_class = 'col-sm-12 col-12';
	break;
	case '2':
	$finbuzz_footer_class = 'col-sm-6 col-12';
	break;
	case '3':
	$finbuzz_footer_class = 'col-lg-4 col-md-6 col-12';
	break;		
	default:
	$finbuzz_footer_class = 'col-lg-3 col-md-6 col-12';
	break;
}
// Logo
$finbuzz_light_logo = empty( FinbuzzTheme::$options['footer_logo_light']['url'] ) ? FINBUZZ_IMG_URL . 'logo-light.svg' : FinbuzzTheme::$options['footer_logo_light']['url'];


$finbuzz_bg_class='';
if( !empty( FinbuzzTheme::$options['f3bgimg'] ) ) {
	$f1_bg = wp_get_attachment_image_src( FinbuzzTheme::$options['f3bgimg'], 'full', true );
	$footer_bg_img = $f1_bg[0];
}else {
	$footer_bg_img = FINBUZZ_IMG_URL . 'footer-3-bg.jpg';
}

if ( FinbuzzTheme::$options['footer3_bgtype'] == 'f3bgcolor' ) {
	$finbuzz_bg = FinbuzzTheme::$options['f3bgcolor'] ? FinbuzzTheme::$options['f3bgcolor']:'#ffffff' ;
	$finbuzz_bg_class='no-footer-img';
} else {
	$finbuzz_bg = 'url(' . $footer_bg_img . ') no-repeat center bottom / cover';
	$finbuzz_bg_class='has-footer-img';
}

?>

<?php if ( FinbuzzTheme::$footer_area == 1 || FinbuzzTheme::$footer_area == 'on') { ?>
	<div class="footer-top-area <?php echo esc_attr( $finbuzz_bg_class ); ?>"  style="background:<?php echo esc_html( $finbuzz_bg ); ?>">
		<div class="container">
			<?php if ( is_active_sidebar( 'footer-style-3-1' ) ) { ?>
				<div class="footer-top-widget">
					<div class="row">
						<?php
						for ( $i = 1; $i <= $finbuzz_footer_column; $i++ ) {
							if(is_active_sidebar( 'footer-style-3-'. $i )){
								echo '<div class="' . $finbuzz_footer_class . '">';
								dynamic_sidebar( 'footer-style-3-'. $i );
								echo '</div>';
							}
						}
						?>
					</div>
				</div>	
			<?php } ?>
			<div class="copyright_wrap">
				<div class="copyright"><?php echo wp_kses( FinbuzzTheme::$options['copyright_text'] , 'allow_link' );?></div>
			</div>
		</div>		
	</div>
<?php } ?>
