<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size 			= 'finbuzz-size7';
$id            			= get_the_id();

$finbuzz_service_icon   		= get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );
$finbuzz_insurance_img   		= get_post_meta( get_the_ID(), 'finbuzz_service_img', true );
$finbuzz_insurance_hover_img   	= get_post_meta( get_the_ID(), 'finbuzz_service_hover_img', true );

$id = get_the_ID();
$content = get_the_content();
$content = apply_filters( 'the_content', $content );
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['service_excerpt_limit'], '' );

?>
<article id="post-<?php the_ID(); ?>">
	<div class="service-item ">
		<div class="service-item-wrap">
			<div class="service-box-content">
				<div class="service-content">
					<h3 class="service-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
					<?php if ( (!empty($finbuzz_service_icon ) || !empty($finbuzz_insurance_img ) || !empty($finbuzz_insurance_hover_img) ) && FinbuzzTheme::$options['service_ar_icon'] ) { ?>
						<?php if ( $finbuzz_insurance_hover_img) : ?>
							<div class="service-img-wrap">	
								<?php if(($finbuzz_insurance_hover_img)): ?>
									<div class="service-hover-img">
									<span><?php echo wp_get_attachment_image($finbuzz_insurance_hover_img);?></span>
									</div>	
								<?php endif; ?>	
							</div>
						<?php else: ?>
							<div class="icon">
								<span><i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i></span>
							</div>
					<?php endif; ?>
					<?php } ?>
					<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
					<?php if ( FinbuzzTheme::$options['service_ar_button'] ) { ?>
							<div class="service-button1">
								<a  href="<?php  the_permalink(); ?>"><i class="fas fa-long-arrow-alt-right"></i></a>
							</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</article>