<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size 			= 'finbuzz-size9';
$id            			= get_the_id();

$finbuzz_service_icon   = get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );
$finbuzz_insurance_img   	= get_post_meta( get_the_ID(), 'finbuzz_service_img', true );
$finbuzz_insurance_hover_img   	= get_post_meta( get_the_ID(), 'finbuzz_service_hover_img', true );
$id = get_the_ID();
$content = get_the_content();
$content = apply_filters( 'the_content', $content );
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['service_excerpt_limit'], '' );
?>
<article id="post-<?php the_ID(); ?>">
	<div class="service-item ">
		<div class="service-box-content">
			<?php
				$thumbnail1="";
				$thumbnail2=""; 
				if ( has_post_thumbnail($post->ID ) ){
					$thumbnail1=wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), $thumb_size  );
				} else {
					
					$thumbnail2=FinbuzzTheme_Helper::get_img( 'noimage_390X340.jpg' );
					
				}
				if(isset($thumbnail1) && !empty($thumbnail1)){
					$thumbnail=$thumbnail1[0];
				}
				if(isset($thumbnail2) && !empty($thumbnail2)){
					$thumbnail=$thumbnail2;
				}
			?>
			<div class="service-figure" data-bg-image=<?php echo esc_attr( $thumbnail ); ?>>
					<div class="service-content">
						<?php if ( (!empty($finbuzz_service_icon ) || !empty($finbuzz_insurance_img ) || !empty($finbuzz_insurance_hover_img) ) && FinbuzzTheme::$options['service_ar_icon'] ) { ?>
							<?php if ( $finbuzz_insurance_img || $finbuzz_insurance_hover_img) : ?>
							<div class="service-img-wrap">
								<?php if(($finbuzz_insurance_img)): ?>
									<div class="service-image">
										<span><?php echo wp_get_attachment_image( $finbuzz_insurance_img );?></span>
									</div>
								<?php endif; ?>	
								<?php if(($finbuzz_insurance_hover_img)): ?>
									<div class="service-hover-img">
									<span><?php echo wp_get_attachment_image($finbuzz_insurance_hover_img);?></span>
									</div>
								<?php endif; ?>	
							</div>
							<?php else: ?>
							<div class="icon">
								<span><i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i></span>
							</div>
						<?php endif; ?>
						<?php } ?>
						<div class="service-info">
							<h3 class="service-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
							<?php if ( FinbuzzTheme::$options['service_ar_button'] ) { ?>
								<div class="service-button1">
									<a class="btn-style1" href="<?php  the_permalink(); ?>"><?php  esc_html_e( 'Read More', 'finbuzz' );?><svg 
									xmlns="http://www.w3.org/2000/svg"
									xmlns:xlink="http://www.w3.org/1999/xlink"
									width="24px" height="24px" viewBox="0 0 24 24">
									<path fill-rule="evenodd" fill="#FA360A" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"/>
									</svg></a>
								</div>
							<?php } ?>
						</div>
					</div>
			</div>
		</div>
	</div>
</article>
