<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size1';

$finbuzz_has_entry_meta  = ( FinbuzzTheme::$options['blog_date'] || FinbuzzTheme::$options['blog_author_name'] || FinbuzzTheme::$options['blog_cats'] || FinbuzzTheme::$options['blog_comment_num'] || FinbuzzTheme::$options['blog_length'] && function_exists( 'finbuzz_reading_time' ) || FinbuzzTheme::$options['blog_view'] && function_exists( 'finbuzz_views' ) ) ? true : false;

$finbuzz_time_html       = sprintf( '<span>%s</span><span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );
$finbuzz_time_html       = apply_filters( 'finbuzz_single_time', $finbuzz_time_html );

$finbuzz_comments_number = number_format_i18n( get_comments_number() );
$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment: ' , 'finbuzz' ) : esc_html__( 'Comments: ' , 'finbuzz' );
$finbuzz_comments_html = $finbuzz_comments_html . '<span class="comment-number">'. $finbuzz_comments_number .'</span> ';

$id = get_the_ID();
$content = get_the_content();
$content = apply_filters( 'the_content', $content );
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['post_content_limit'], '' );

if ( empty(has_post_thumbnail() ) ) {
	$img_class ='no_image';
}else {
	$img_class ='show_image';
}

?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'blog-layout-2' ); ?>>
	<div class="blog-list  <?php echo esc_attr($img_class); ?>">
		<?php if ( has_post_thumbnail() || FinbuzzTheme::$options['display_no_preview_image'] == '1'  ) { ?>
			<div class="blog-img-holder">
				<div class="blog-img">
					<a href="<?php the_permalink(); ?>" class="img-opacity-hover"><?php if ( has_post_thumbnail() ) { ?>
						<?php the_post_thumbnail( $thumb_size, ['class' => 'img-responsive'] ); ?>
						<?php } else {
							if ( FinbuzzTheme::$options['display_no_preview_image'] == '1' ) {
								if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
									$thumbnail = wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );						
								}
								elseif ( empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
									$thumbnail = '<img class="wp-post-image" src="'.FINBUZZ_IMG_URL.'noimage_870X525.jpg" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
								}
								echo wp_kses( $thumbnail , 'alltext_allow' );
							}
						}
					?>
					</a>
				</div>
			</div>
		<?php } ?>
		<div class="entry-content">
			<?php if ( $finbuzz_has_entry_meta ) { ?>
			<ul class="entry-meta">
				<?php if ( FinbuzzTheme::$options['blog_date'] ) { ?>			
					<li class="blog-date">
					<i class="fas fa-calendar-alt"></i><?php echo get_the_date(); ?>	
					</li>	
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['blog_author_name'] ) { ?>
					<li class="item-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz' );?><?php the_author_posts_link(); ?></li>
				<?php } ?>
				<?php  if ( FinbuzzTheme::$options['blog_cats'] ) { ?>
				<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['blog_comment_num'] ) { ?>
				<li class="blog-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses( $finbuzz_comments_html , 'alltext_allow' );?>
					</a>
			    </li>
				<?php } if ( FinbuzzTheme::$options['blog_length'] && function_exists( 'finbuzz_reading_time' ) ) { ?>
				<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
				<?php } if ( FinbuzzTheme::$options['blog_view'] && function_exists( 'finbuzz_views' ) ) { ?>
				<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
				<?php } ?>
			</ul>
			<?php } ?>
			<h3 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php if(FinbuzzTheme::$options['blog_content']){ ?>
				<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
				<div>
					<a href="<?php the_permalink();?>" class="btn-style1"><?php esc_html_e( 'Read more ', 'finbuzz' );?>
					<svg 
					xmlns="http://www.w3.org/2000/svg"
					xmlns:xlink="http://www.w3.org/1999/xlink"
					width="24px" height="24px" viewBox="0 0 24 24">
					<path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
					d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
					</svg></a>
				</div>
			<?php } ?>		
		</div>
	</div>
</div>