<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */


// Layout class

if ( FinbuzzTheme::$layout == 'full-width' ) {
	$finbuzz_layout_class = 'col-sm-12 col-xs-12';
	$col_class    = 'col-lg-4 col-md-6 col-sm-6 col-xs-12 no-equal-item';
}
else{
	$finbuzz_layout_class = 'col-lg-9 col-12';
	$col_class    = 'col-lg-6 col-md-6 col-sm-6 col-xs-12 no-equal-item';
}

// Template

$template_bg_sty		= 'bg-light-accent100';
$gutters				= '';
$container_class		= 'container';
$iso					= 'no-equal-gallery rt-masonry-grid';
$bg_image='no-bg-image';
if ( FinbuzzTheme::$options['services_style'] == 'style1' ){
	$services_archive_layout = "service-default service-grid-layout1";
	$template 				 = 'service-1';
	$col_class    = 'col-lg-6 col-md-12 col-sm-12 col-xs-12 no-equal-item';
}elseif( FinbuzzTheme::$options['services_style'] == 'style2' ){
	$services_archive_layout = "service-default service-grid-layout2";
	$template 				 = 'service-2';
	$col_class               = 'col-lg-4 col-md-6 col-sm-6 col-xs-12 no-equal-item';
}else{
	$services_archive_layout = "service-default service-grid-layout1";
	$template 				 = 'service-1';
}


?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="service-archive-wrap ">
		<div class="container">
			<div class="row">
				<?php
				if ( FinbuzzTheme::$layout == 'left-sidebar' ) {
					if ( is_active_sidebar( 'service-sidebar' ) ) {
						get_sidebar('finbuzz_service');
					}
				}?>
				<div class="<?php echo esc_attr( $services_archive_layout );?> <?php echo esc_attr( $finbuzz_layout_class );?>">
					<main id="main" class="site-main">
						<div class="rt-sidebar-sapcer">
							<?php if(category_description(  )){ ?>
								<div class="category-description">
									<?php echo category_description(); ?>
								</div>
							<?php } ?>			
							<?php 
							$delay = 200;
							if ( have_posts() ) :?>
								<div class="row">
									<?php while ( have_posts() ) : the_post(); ?>
										<div class="rt-grid-item <?php echo esc_attr( $col_class );?> wow fadeInUp" data-wow-delay="<?php echo esc_attr( $delay."ms" ); ?>" data-wow-duration="1200ms">
											<?php get_template_part( 'template-parts/content', $template ); ?>
										</div>
									<?php 
									$delay+=100 ;
									endwhile; ?>
								</div>

							<?php FinbuzzTheme_Helper::pagination(); ?>	
							<?php else:?>
								<?php get_template_part( 'template-parts/content', 'none' );?>
							<?php endif;?>
						</div>
					</main>
				</div>
				<?php
				if ( FinbuzzTheme::$layout == 'right-sidebar' ) {				
					if ( is_active_sidebar( 'service-sidebar' ) ) {
						get_sidebar('finbuzz_service');
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>
