<?php
/**
 * SHopbuilder exist or not.
 */
if( ! function_exists( 'rtsb' ) ){
	return;
}

/**
 * Main StorefrontSupport class Only Work for storefront theme.
 *
 * @package RadiusTheme\SB
 */


use RadiusTheme\SB\Traits\SingletonTrait;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class ThemeSupport {
	/**
	 * Singleton
	 */
	use SingletonTrait;

	/**
	 * Construct function
	 */
	private function __construct() {
		add_filter( 'loop_shop_per_page', [ __CLASS__, 'finbuzz_loop_shop_per_page' ], 21 );
	}

	public static function finbuzz_loop_shop_per_page() {
		$products_row = absint( get_option( 'woocommerce_catalog_rows', 4 ) );
		$products_col = absint( get_option( 'woocommerce_catalog_columns', 4 ) );

		return $products_row * $products_col;
	}
}
