<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$primary_color     = FinbuzzTheme::$options['primary_color']; // #0f5bf5
$primary_rgb       = FinbuzzTheme_Helper::hex2rgb( $primary_color ); // 15, 91, 245
$secondary_color   = FinbuzzTheme::$options['secondary_color']; // #03359b
$secondary_rgb     = FinbuzzTheme_Helper::hex2rgb( $secondary_color ); // 253, 201, 2
$gradient_dark_color   = FinbuzzTheme::$options['gradient_dark_color'];
$gradient_light_color  = FinbuzzTheme::$options['gradient_light_color'];

/*---------------------------------    
INDEX
===================================
#. EL: Button
#. EL: Section Title
#. EL: Slider
#. EL: Owl Nav 1
#. EL: Owl Nav 2
#. EL: Owl Nav 3
#. EL: Text/image With Button
#. EL: Info Box
#. EL: Counter
#. EL: Team
#. EL: Gallery
#. EL: Service Layout
#. EL: Service Layout
#. EL: Testimonial
#. EL: Post Grid
#. EL: Pricing Table
#. EL: Tab Form
#. EL: Widget
#. EL: Others

----------------------------------*/

/*-----------------------
#. EL: Button
------------------------*/
?>

.btn-style3{
	background:<?php echo esc_html($primary_color); ?>
}
.btn-style3:hover svg path{
	fill:<?php echo esc_html($primary_color); ?>
}
.btn-style5 svg path,
.btn-style8 svg path,
.btn-style7 svg path{
	fill:<?php echo esc_html($primary_color); ?>;
}
.btn-style5:hover,
.btn-style9::before{
	background-color:<?php echo esc_html($primary_color); ?>;
}
.loadMore{
	border-color:<?php echo esc_html($primary_color); ?>;
}
.loadMore:hover,
.btn-style6:hover,
.btn-style7:hover{
	color:<?php echo esc_html($primary_color); ?>;
}
.btn-style6::before,
.btn-style6::after{
	background-color:<?php echo esc_html($primary_color); ?>;
}
.btn-style8{
	border-color:<?php echo esc_html($primary_color); ?>;
	color:<?php echo esc_html($primary_color); ?>;
}
.info-style9 .info-item:hover .info-button7 .btn-style8
{
    background-color: <?php echo esc_html($primary_color); ?>;
    border: 1px solid<?php echo esc_html($primary_color); ?>;
}
.service-grid-layout6 .service-item:hover .btn-style8:hover,
.portfolio-multi-layout-9 .rtin-item .item-img .rtin-content .content_inner .round-button .round-btn i{
	color:<?php echo esc_html($primary_color); ?>;
}
.btn-wrap .btn-style9::before,
.portfolio-multi-layout-9 .rtin-item .item-img .rtin-content .content_inner .round-button .round-btn:hover,
.info-style13 .info-item:after{
	background-color:<?php echo esc_html($primary_color); ?>;
}
<?php
/*-----------------------
#. EL: Section Title
------------------------*/
?>
.sec-title .sub-title {
	color: <?php echo esc_html($primary_color); ?>;
}
.section-title h2:after,
.sec-title.style2 .rtin-title:before,
.sec-title.style2 .rtin-title:after,
.sec-title.style1 .sec-title-holder .rtin-title::after
{
	background: <?php echo esc_html($primary_color); ?>;
}
.sec-title.style2 .section-title span {
	color: <?php echo esc_html($primary_color); ?>;
}
.barshow .title-bar,
.about-info-text h2:after {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.sec-title.style4 .rtin-title:after {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.sec-title.style1 .sec-title-holder .rtin-title::before{
	background: <?php echo esc_html($secondary_color); ?>;
}
<?php
/*-----------------------
#. EL: Slider
------------------------*/
?>
.banner-slider-addon .main-banner-slider .play-btn .play-icon,
.banner-slider-addon .banner-content .banner-btn-list li a span i{
	color: <?php echo esc_html( $primary_color );?>;
}
.banner-slider-addon  .banner-content .banner-btn-list li a:hover{
	background-color: <?php echo esc_html( $primary_color );?>;
}
.banner-slider-addon  .banner-content .banner-btn-list li a svg path{
	fill:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. EL: Text/image With Button
-------------------------------*/
?>
.barshow .title-bar2{
	background-color:<?php echo esc_html($primary_color); ?>;
}
.barshow .title-bar1{
	background-color:<?php echo esc_html($secondary_color); ?>;
}
.about-image-text .about-content .sub-rtin-title,
.title-text-button .subtitle{
	color: <?php echo esc_html($primary_color); ?>;
}


<?php
/*-------------------------------------
#. EL: Owl Nav 1
---------------------------------------*/
?>
.rt-owl-nav-1.slider-nav-enabled .owl-carousel .owl-nav > div {
	background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1.slider-nav-enabled .owl-carousel .owl-nav > div:hover {
	background-color: <?php echo esc_html($secondary_color); ?>;
}
.rt-owl-nav-1.slider-dot-enabled .owl-carousel .owl-dot:hover span,
.team-grid-style2.rt-owl-nav-1.slider-dot-enabled .owl-carousel .owl-dot.active span,
.rt-owl-nav-1.slider-dot-enabled .owl-carousel .owl-dot.active span,
.team-multi-layout-3 .rtin-item .rtin-designation::after,
.team-multi-layout-3 .rtin-item .rtin-social > li> a,
.team-multi-layout-3 .rtin-item .rtin-social li ul li a,
.team-grid-style2 .swiper-pagination span.swiper-pagination-bullet-active,
.team-multi-layout-4 .rtin-item .rtin-content-wrap .mask-wrap .rtin-content .rtin-title::after,
.team-multi-layout-4 .rtin-item .rtin-social li ul li a:hover,
.team-multi-layout-5 .rtin-item:hover  .rtin-content-wrap .mask-wrap,
.team-multi-layout-5 .rtin-item .rtin-social li ul li a:hover
{
	background-color: <?php echo esc_html($primary_color); ?>;
}
.team-multi-layout-3 .rtin-item .rtin-social li ul li a:hover{
	color:<?php echo esc_html($primary_color); ?>;
}
.team-multi-layout-4 .rtin-item svg path{
	fill:<?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. EL: Owl Nav 2
---------------------------------------*/
?>
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot:hover span,
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot.active span {
	background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-nav > div:hover {
	background: <?php echo esc_html($secondary_color); ?>;
}
<?php
/*-------------------------------------
#. EL: Info Box
---------------------------------------*/
?>
.info-box .info-title a:hover,
.info-style1 .info-item .info-icon,
.info-style2 .info-item .info-title a:hover,
.info-style1 .info-item .info-content .info-title a:hover, 
.info-box .info-item .info-price,
.info-style3 .media-icon .info-icon,
.info-style10 .info-item .info-text,
.info-style3 .info-item .info-button .button,
.info-style2 .info-item .info-button .button,
.info-style13 .info-icon,
.info-style14 .info-item:hover .info-icon,
.info-style7 .info-item .info-button .button{
    color: <?php echo esc_html($primary_color); ?>;
}

.info-style5 .info-item .info-button .info-button {
	border-color: <?php echo esc_html($secondary_color); ?>;
}

.info-style3 .info-item .info-button .info-button,
.info-style2 .info-item .info-button .info-button,
.info-style5 .info-item .link-shape .info-button a:hover,
.info-style7 .info-item:hover .info-title,
.info-style8  .info-item:hover .icon-circle-box .icon-body .info-icon i,
.info-style12 .info-item .info-content .info-title a:hover,
.info-style12 .info-item .info-content .info-title:hover
{
	color:<?php echo esc_html($primary_color); ?>;
} 
.info-style1 .info-item:hover .info-media .info-number{
	border-color:transparent transparent <?php echo esc_html($primary_color); ?> transparent;
}
.info-box.info-style2 .info-item:before,
.info-style4 .info-item:hover .info-content .info-button .btn-style4::after,
.info-style7 .info-item:hover .rtin-media::before,
.info-style7 .info-item:hover .rtin-media::after{
	background-color:<?php echo esc_html($primary_color); ?>;
}
.info-style5 .info-item::before{
	background-image: linear-gradient(to top,<?php echo esc_html( $primary_color );?>, transparent);
}
.info-style8 .info-item .icon-circle-box .circle-image svg path:nth-child(1),
.info-style8 .info-item .icon-circle-box .circle-image svg path:nth-child(2),
.info-style8 .info-item .icon-circle-box .circle-image svg path:nth-child(4),
.info-style11 .info-item .info-box-memo li:nth-child(3) svg path{
	fill:<?php echo esc_html($primary_color); ?>;
}
.info-style11 .info-item .info-box-memo li:nth-child(2) svg path{
	stroke:<?php echo esc_html($primary_color); ?>;
}
.info-style12 .info-item:hover .info-media .info-number{
	border-color: transparent transparent <?php echo esc_html($primary_color); ?>; transparent;
}
<?php
/*-----------------------
#. EL: Counter
------------------------*/
?>


.rt-counter.rtin-counter-style1 .rtin-item .rtin-content .rtin-counter .success-count::after, 
.rt-counter.rtin-counter-style2 .rtin-item .rtin-content .rtin-counter .success-count::after{
	background-color: <?php echo esc_html($primary_color); ?>;
}

.rt-counter.rtin-counter-style3 .rtin-item::after{
	background-color: <?php echo esc_html($primary_color); ?>;
} 

<?php
/*------------------------------
#. EL: Testimonial
--------------------------------*/
?>

.testimonial-2 .slick-slide .testimonial-content-wrap .person-info:before,
.testimonial-1 .slick-arrow:hover,
.testimonial-1 .slick-prev:hover,     
.testimonial-1 .slick-next:hover,
.testimonial-1 .slick-prev:focus, 
.testimonial-1 .slick-next:focus,
.testimonial-4 .testimonial-item .testimonial-top-area .testimonial-figure .item-icon i,
.testimonial-4 .testimonial-item .testimonial-designation:after,
.testimonial-5 .testimonial-item .testimonial-designation:after,
.testimonial-5 .rt-related-slider .swiper-button-next:hover,
.testimonial-6 .swiper-pagination .swiper-pagination-bullet-active,
.testimonial-5 .rt-related-slider .swiper-button-prev:hover{
	background-color: <?php echo esc_html($primary_color); ?>;
} 

.testimonial-2 .slick-arrow:hover:before,
.testimonial-6 .testimonial-item .testimonial-content .test-footer .author-info .testimonial-title,
.testimonial-3 .rt-related-slider .swiper-button > div{
	color:<?php echo esc_html($primary_color); ?>;
}
.testimonial-5 .testimonial-item .person-info p{
	border-color:<?php echo esc_html($primary_color); ?>;
} 
<?php
/*------------------------------
#. EL: Service Layout
--------------------------------*/
?>

.service-grid-layout1 .service-content .service-title a:hover,
.service-grid-layout2 .service-item .service-title a:hover,
.service-grid-layout4 .service-item:hover .service-content .service-title a {
    color: <?php echo esc_html($primary_color); ?>;
}
.service-grid-layout1 .service-item:hover .service-title a,
.service-grid-layout1 .service-item:hover .service-title
{
    color: #fff;
}
.service-grid-layout1 .service-item:hover .service-box-content .btn-style1,
.service-layout5 .swiper-pagination .swiper-pagination-bullet-active{
	background-color: <?php echo esc_html($primary_color); ?>;
	border-color: <?php echo esc_html($primary_color); ?>;
}
.service-grid-layout7 .service-item .service-content .service-title::before,
.service-grid-layout7 .service-item:hover .service-content{
	background-color: <?php echo esc_html($primary_color); ?>;
}
.service-grid-layout7 .service-item:hover .service-content .service-title::before{
	background-color:#fff;
}
<?php
/*------------------------------
#. EL: Post Grid
--------------------------------*/
?>

.post-default .post-grid-item .entry-content h3 a:hover,
.post-grid-style6 .blog-date i,
.post-grid-style6 .post-grid-meta li i,
.post-grid-style6 .post-grid-meta li a:hover,
.post-grid-style1 .post-grid-item .entry-content ul li i,
.post-grid-style1 .post-grid-item .blog-btn:hover,
.post-multi-grid .rtin-item-post .rtin-title a:hover{
	color:<?php echo esc_html( $primary_color );?>;
}

.post-grid-style1 .post-grid-item  .entry-content .blog-date:after,
.post-grid-style6 .rtin-img:after,
.post-grid-style6 .rtin-img:before,
.post-grid-style5 .blog-button a{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.post-grid-style2 .post-grid-item .entry-content .blog-btn svg path,
.post-multi-grid .rtin-item-post  .blog-btn svg path{
	fill:<?php echo esc_html( $primary_color );?>;
}
.post-grid-style2 .post-grid-item .post-img .blog-cat a:hover{
	background-color:<?php echo esc_html( $primary_color );?>;
	color:#fff;
}
.post-grid-style2 .post-grid-item .entry-content .blog-btn:hover,
.post-multi-grid .rtin-item-post .blog-btn:hover,
.post-grid-style2 .post-grid-item .entry-content .post-grid-meta li a:hover,
.post-grid-style2 .post-grid-item .entry-content .post-grid-meta li i,
.post-grid-style4 .rtin-item-post .rtin-content ul li i{
	color:<?php echo esc_html( $primary_color );?>
}
.post-default.post-grid-style3 .rtin-item-post .rtin-img .blog-date,
.post-default.post-grid-style4 .rtin-item-post .blog-date{
	background:<?php echo esc_html( $primary_color );?>
}
.btn-wrap .btn-style9:hover{
	border-color:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. EL: Tab Form
--------------------------------*/
?>

.rtin-insurance-tab.tab-style1 .feature-tab-layout ul.nav-tabs .nav-item a.active{
	background:<?php echo esc_html( $primary_color );?>;
	border-color:<?php echo esc_html( $primary_color );?>;
}
.rtin-insurance-tab.tab-style1 .feature-tab-layout ul.nav-tabs .nav-item a:after{
	border-top: 16px solid <?php echo esc_html( $primary_color );?>;
}
.rtin-insurance-tab.tab-style2 .rtin-item .insur-tab-more:hover,
.rtin-insurance-tab.tab-style2 .nav-tabs .nav-item a::before{
	background:<?php echo esc_html( $primary_color );?>;
}
.rtin-insurance-tab.tab-style2 .rtin-item ul li:after{
	color:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. EL: Widget
--------------------------------*/
?>
.fixed-sidebar-left .elementor-widget-wp-widget-nav_menu ul > li > a:hover,
.fix-bar-bottom-copyright .rt-about-widget ul li a:hover, 
.fixed-sidebar-left .rt-about-widget ul li a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.element-side-title h5:after {
    background: <?php echo esc_html( $secondary_color );?>;
}
<?php
/*------------------------------
#. EL: Others
--------------------------------*/
?>
.element-side-title h5 {
    color: <?php echo esc_html( $primary_color );?>;
}
.fixed-sidebar-addon .elementor-widget-wp-widget-nav_menu ul > li > a:hover,
.fixed-sidebar-addon .rt-about-widget .footer-social li a:hover {
    color: <?php echo esc_html( $primary_color ); ?>;
}
.rt-cat-list-widget li:before,
.rtin-faq .faq-item .faq-number span {
    background: <?php echo esc_html( $primary_color );?>;
}
.elementor-icon-list-items .elementor-icon-list-item i,
.address-style2 .rtin-item:hover .rtin-icon i {
    color: <?php echo esc_html( $primary_color ); ?>;
}
.rtin-address-default .rtin-item .rtin-info a:hover,
.rtin-address-default .rtin-item .rtin-icon i {
	color: <?php echo esc_html( $secondary_color );?>;
}
.rtin-logo-slider .rtin-item:hover {
    border-color: <?php echo esc_html($primary_color); ?>;
}
.elementor-accordion .elementor-tab-title.elementor-active .elementor-accordion-icon-opened {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php
/*------------------------------
#. call to action
--------------------------------*/
?>
.cta-style1 .action-box,
.cta-default.cta-style6::after,
.counter-style5 .success-count-wrap,
.post-grid-style7 .blog-date,
.cta-style7 .action-box,
.portfolio-multi-layout-8.portfolio-layout11 .rtin-item .rtin-content h3::before,
.rtin-contact-info-default.info-style4 .list-icon:hover,
.cta-style8 .action-box .cta-button .btn-style5,
.service-grid-layout9 .service-box-content .content-header::before,
.testimonial-slider-style9 .testimonial-content .heading .shape,
.cta-style7::after{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.cta-style1:after,
.single-service-cta .cta-style1:after{
	background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.2);
}
.cta-style1:before,
.single-service-cta .cta-style1:before{
	background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.1);
}
.image-style7 .image-box .images-shape li.red-shape svg path,
.cta-style4 .btn-style1:hover svg path,
.cta-style8 .action-box .cta-button .btn-style5:hover svg path,
.cta-style6 .action-box .btn-style1:hover svg path,
.post-grid-style7 .post-grid-item .entry-content .post-grid-meta li svg path,
.btn-style1 svg path,
.portfolio-multi-layout-8.portfolio-layout11 .rtin-item .port-btn:hover svg path,
.cta-style7 .action-box .btn-style1:hover svg path{
	fill:<?php echo esc_html( $primary_color );?>
}
.image-style7 .image-box .images-shape li.red-shape svg path,
.topbar-style-5 .top-bar-wrap svg path{
	stroke:<?php echo esc_html( $primary_color );?>
}

.service-grid-layout6 .service-item:after,
.portfolio-multi-layout-6 .rtin-item:after{
	background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.79);
}
.service-multilayout-2.service-grid-layout10 .service-item:after{
	background-color:rgba(<?php echo esc_html( $primary_rgb );?>, 1);
}
.post-grid-multilayout .post-grid-item .entry-content .post-grid-meta li i,
.service-grid-layout6 .service-item .btn-style7,
.service-multilayout-2 .service-item:hover .btn-style8:hover,
.cta-style8 .action-box .cta-button .btn-style5:hover,
.rtin-contact-info-default.info-style4 .list-content a:hover{
	color:<?php echo esc_html( $primary_color );?>;
}

.service-grid-layout6 .service-item:hover .btn-style7,
.service-grid-layout6 .service-item:hover .btn-style7 svg path{
	color:#fff;
	fill:#fff;
}

<?php
/*------------------------------
#. video
--------------------------------*/
?>
.rt-video .rtin-video .rtin-play .play-icon,
.video-slider.video-style5 .play-btn .play-icon{
	color:<?php echo esc_html( $primary_color );?>
}
.video-style6 .rtin-play{
	border-color:<?php echo esc_html( $primary_color );?>;
}
.rt-video.video-style2,
.video-style6 .rtin-play:hover,
.title-text-button  .subtitle.style3::before,
.video-slider.video-style5 .video-gallery-slider .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active,
.video-style4 .rtin-video  .rtin-play .play-text::before{
	background-color:<?php echo esc_html( $primary_color );?>
} 
<?php
/*------------------------------
#. progress circular
--------------------------------*/
?>
.progress-circular-layout .progress-circular span i{
	color:<?php echo esc_html( $primary_color );?>;
}
.progress-circular-layout .progress-circular-wrap:after{
	background:<?php echo esc_html( $primary_color );?>;
}
.progress-circular-layout .progress-circular:after,
.progress-circle .style-2.has-shape::before{
	background:<?php echo esc_html( $primary_color );?>;
}

<?php
/*------------------------------
#. counter
--------------------------------*/
?>
.counter-style1 .success-count-wrap::after,
.counter-style2 .success-count-wrap .count:after,
.counter-style3 .success-count-wrap .count:after{
	background:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. Fluent form
--------------------------------*/
?>
.fluentform-widget-title::before{
	background:<?php echo esc_html( $secondary_color );?>;
}
.fluentform-widget-title::after,
.fluentform  .frm-fluent-form .callback-btn,
.fluentform  .frm-fluent-form .free-consultation-btn .ff-btn-submit{
	background:<?php echo esc_html( $primary_color );?>;
}
.fluentform .frm-fluent-form .ff-el-form-control:focus{
	border-color:<?php echo esc_html( $primary_color );?>;
}
.fluentform  .frm-fluent-form .callback-btn:hover,
.fluentform  .frm-fluent-form .free-consultation-btn .ff-btn-submit:hover{
	color:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. Portfolio style
--------------------------------*/
?>
.portfolio-single .cat-list a,
.portfolio-single  .portfoilo-info-wrap ul.project-list li.post-share .share-links a:hover,
.portfolio-single .portfolio-post-navigation  .pad-lr-15 .portfolio-icon a,
.portfolio-single .portfolio-post-navigation  .pad-lr-15 .portfolio-content h3 a:hover,
.portfolio-single .single-port-cat a,
.portfolio-multi-layout-4 .rtin-item .rtin-figure .read-more-btn,
.portfolio-multi-layout-5 .read-more-btn:hover,
.portfolio-multi-layout-10 .rtin-item .rtin-cat a:hover,
.portfolio-multi-layout-5 .rtin-item .rtin-content .cat-list a,
.portfolio-multi-layout-6 .rtin-item  .portfolio-btn .read-more-btn:hover,
.portfolio-default.portfolio-layout7   .rtin-item .rtin-content .read-more-btn,
.portfolio-default.portfolio-layout7 .rtin-item .rtin-content .title-area h3 a:hover,
.portfolio-multi-layout-8 .rtin-item .rtin-content h3 a:hover
 {
	color:<?php echo esc_html( $primary_color );?>;
}

.portfolio-multi-layout-1 .rtin-item::before
{
	background-image: linear-gradient(to top,<?php echo esc_html( $primary_color );?>, transparent);
}
.portfolio-single .portfoilo-info-wrap .info-title,
.portfolio-multi-layout-2 .rtin-item .rtin-figure .rtin-content .cat-list::after,
.portfolio-single .portfolio-post-navigation  .pad-lr-15:hover .portfolio-icon a,
.portfolio-multi-layout-4 .rtin-item .rtin-content::before,
.portfolio-multi-layout-5 .rtin-item .rtin-content,
.portfolio-multi-layout-5 .swiper-button-next:hover,
.portfolio-multi-layout-5 .swiper-button-prev:hover,
.portfolio-multi-layout-10  .swiper-pagination-bullets .swiper-pagination-bullet-active,
.portfolio-default.portfolio-layout7 .rtin-item .rtin-content .title-area::after,
.portfolio-default.portfolio-layout7 .rtin-item:hover .rtin-content .read-more-btn,
.portfolio-multi-layout-8 .rtin-item .rtin-content .portfolio-btn,
.testimonial-8 .swiper-pagination .swiper-pagination-bullet-active,
.portfolio-multi-layout-8 .rtin-item .rtin-content .portfolio-btn:hover
{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.portfolio-multi-layout-2 .rtin-item .rtin-figure .rtin-content .cat-list::before{
	background-color:<?php echo esc_html( $secondary_color );?>;
}
.testimonial-7 .testimonial-item .qoute-icon,
.testimonial-8 .testimonial-item .testimonial-designation{
	color:<?php echo esc_html( $primary_color );?>;
}
.cta-style6 .action-box .btn-style1 svg path{
	fill:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. Contact Info
--------------------------------*/
?>
.contact-info-default .contact-info .section-line-one {
	background-color:<?php echo esc_html( $secondary_color );?>;
}
.contact-info-default .contact-info .section-line-two,
.contact-info-default.info-style2 .contact-info .contact-icon span:after,
.rtin-contact-info-default.info-style3 .list-item::before{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.rtin-contact-info-default.info-style4 .list-icon{
	color:<?php echo esc_html( $primary_color );?>;
	border-color:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. Slider
--------------------------------*/
?>

.main-banner-slider .swiper-button-next:hover, .main-banner-slider .swiper-button-prev:hover{
	color:#fff;
	background:<?php echo esc_html( $primary_color );?>;
}
.banner-slider-addon .main-banner-slider .single-slider .banner-content .banner-title:before,
.main-banner-slider .swiper-pagination-bullet-active,
.banner-addon .banner-title::before,
.rt-video.video-style7 .rtin-video .play-icon:hover,
.main-banner-slider3 .swiper-button-next:hover, 
.main-banner-slider3 .swiper-button-prev:hover{
	background:<?php echo esc_html( $primary_color );?>;
}
.main-banner-slider.slider-style2 .slider-social-section li span,
.main-banner-slider.slider-style2 .slider-social-section li a:hover,
.banner-slider-addon .main-banner-slider .single-slider .banner-content .subtitle,
.banner-social-section li span,
.banner-addon .banner-social-section li a:hover,
.banner-slider-addon.slider-style3 .main-banner-slider3 .play-btn .play-icon,
.main-banner-slider3 .swiper-button-next,
.main-banner-slider3 .swiper-button-prev, 
.video-play-icon{
	color:<?php echo esc_html( $primary_color );?>;
}
.main-banner-slider .swiper-pagination-bullet-active:after
{
	background:<?php echo esc_html( $secondary_color );?>;
} 
<?php
/*------------------------------
#. Image Addon Style 
--------------------------------*/
?>
.image-style1 .image-box  .about-shape li:nth-child(2){
	border-bottom: 55px solid <?php echo esc_html( $primary_color );?>;
}
.image-style1 .image-box  .about-shape li:nth-child(3){
	border: 5px solid <?php echo esc_html( $primary_color );?>;
}
.image-style2 .image-box .quotetion-icon,
.image-style13 .round-shape,
.image-style1 .image-box .image-info{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.animate-image-style7 .shape-point .start-point i,
.service-grid-layout9 .portfolio-btn a:hover,
.animate-image-style7 .shape-point .end-point i{
	color:<?php echo esc_html( $primary_color );?>;
}
.animate-image-style7 .has-animation svg path:nth-child(1){
	stroke:<?php echo esc_html( $primary_color );?>;
}
.image-style11 .image-box li:nth-child(2) svg path,
.image-style12 .shape-icon svg path,
.image-style12 .shape-icon2 svg path{
	fill:<?php echo esc_html( $primary_color );?>;
}
.image-style11 .image-box li:nth-child(3) svg path{
	stroke:<?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------
#. Pricing table
--------------------------------*/
?>
.pricing-plan .pricing-title:after,
.content-toggle .nav-tabs .nav-link.active,
.pricing-switch-container .switch-button{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.pricing-plan .pricing-title:before
{
	background-color:<?php echo esc_html( $secondary_color );?>;
}
.pricing-plan .pricing-btn a,
.pricing--style-2 .pricing__content .pricing__price-heading .price-box .pricing__price{
	color:<?php echo esc_html( $primary_color );?>;
}
.pricing-plan .pricing-btn a:hover,
.pricing--style-2:hover .pricing__content .pricing-button .pricing-btn{
	background-color:<?php echo esc_html( $primary_color );?>;
	color:#fff;
	border-color: <?php echo esc_html( $primary_color );?>;
}
.pricing--style-2:hover{
	border-color:<?php echo esc_html( $primary_color );?>;
} 
<?php
/*------------------------------
#. Country location
--------------------------------*/
?>
.country-location .location-item .map-icon ul li{
	color:<?php echo esc_html( $primary_color );?>;
}
@keyframes pulse {
    0% {
      box-shadow: 0 0 0 0 <?php echo esc_html( $primary_color );?>;
    }
    70% {
      box-shadow: 0 0 0 20px rgba(12, 31, 215, 0);
    }
    100% {
      box-shadow: 0 0 0 0 rgba(12, 31, 215, 0);
    }
}
<?php
/*------------------------------
#. Accordion
--------------------------------*/
?>

.rt-accordion .accordion-button.collapsed:before,
.rt-accordion .accordion-header button,
.accordion-style-2 .accordion-button::before{
	color:<?php echo esc_html( $primary_color );?>;
}
.rt-accordion.accordion-style-3 .accordion-button.collapsed:before{
	color:#fff;
} 

.rt-related-slider .section-title .swiper-button > div:hover,
.accordion-style-4 .accordion-button::before{
	background-color:<?php echo esc_html( $primary_color );?>;
}

.gmap-section .left .elementor-element-populated:after{
	background-color:<?php echo esc_html( $primary_color );?>;
}

.title-text-button .subtitle.style2{
	color:<?php echo esc_html( $primary_color );?>;
	border-color:<?php echo esc_html( $primary_color );?>;
}
.cta-style4,
.cta-style5::before,
.cta-style5::after {
	background-color:<?php echo esc_html( $primary_color );?>;
}
