<?php
/*
Plugin Name: Finbuzz Core
Plugin URI: https://www.radiustheme.com
Description: Finbuzz Core Plugin for Finbuzz Theme
Version: 2.0.1
Author: RadiusTheme
Author URI: https://www.radiustheme.com
*/

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'FINBUZZ_CORE' ) ) {
	define( 'FINBUZZ_CORE',                   ( WP_DEBUG ) ? time() : '1.0' );
	define( 'FINBUZZ_CORE_THEME_PREFIX',      'finbuzz' );
	define( 'FINBUZZ_CORE_THEME_PREFIX_VAR',  'finbuzz' );
	define( 'FINBUZZ_CORE_CPT_PREFIX',        'finbuzz' );
	define( 'FINBUZZ_CORE_BASE_DIR',      plugin_dir_path( __FILE__ ) );
	//for tween max added code
	define( 'FINBUZZ_CORE_BASE_URL',      plugin_dir_url( __FILE__ ) );

}

class Finbuzz_Core {

	public $plugin  = 'finbuzz-core';
	public $action  = 'finbuzz_theme_init';

	public function __construct() {
		$prefix = FINBUZZ_CORE_THEME_PREFIX_VAR;

		add_action( 'plugins_loaded', array( $this, 'demo_importer' ), 15 );
		add_action( 'plugins_loaded', array( $this, 'load_textdomain' ), 16 );
		add_action( 'after_setup_theme', array( $this, 'post_meta' ), 15 );
		add_action( 'after_setup_theme', array( $this, 'elementor_widgets' ) );
		add_action( $this->action,       array( $this, 'after_theme_loaded' ) );

		add_shortcode('finbuzz-single-portfolio-info', array( $this, 'finbuzz_single_portfolio_info' ) );


		require_once 'module/rt-post-share.php';
		require_once 'module/rt-post-views.php';
		require_once 'module/rt-post-length.php';

		// Widgets
		require_once 'widget/about-widget.php';
		require_once 'widget/address-widget.php';
		require_once 'widget/social-widget.php';
		require_once 'widget/rt-recent-post-widget.php';
		require_once 'widget/rt-post-box.php';
		require_once 'widget/rt-post-tab.php';
		require_once 'widget/rt-feature-post.php';
		require_once 'widget/search-widget.php'; 
		require_once 'widget/rt-download-widget.php';
		require_once 'widget/rt-calltoaction-widget.php';

		//

		require_once 'widget/widget-settings.php';
		require_once 'lib/optimization/__init__.php';
	}



	/**
	 * Removes the demo link and the notice of integrated demo from the redux-framework plugin
	*/

	public function demo_importer() {
		require_once 'demo-importer.php';
	}
	public function load_textdomain() {
		load_plugin_textdomain( $this->plugin , false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}
	public function post_meta(){
		if ( !did_action( $this->action ) || ! defined( 'RT_FRAMEWORK_VERSION' ) ) {
			return;
		}
		require_once 'post-meta.php';
		require_once 'post-types.php';
	}
	public function elementor_widgets(){
		if ( did_action( $this->action ) && did_action( 'elementor/loaded' ) ) {

			require_once 'elementor/init.php';
		}
	}
	public function after_theme_loaded() {
		require_once FINBUZZ_CORE_BASE_DIR . 'lib/wp-svg/init.php'; // SVG support
		//require_once 'widget/sidebar-generator.php'; // sidebar widget generator
	}

	public function get_base_url(){

		$file = dirname( dirname(__FILE__) );

		// Get correct URL and path to wp-content
		$content_url = untrailingslashit( dirname( dirname( get_stylesheet_directory_uri() ) ) );
		$content_dir = untrailingslashit( WP_CONTENT_DIR );

		// Fix path on Windows
		$file = wp_normalize_path( $file );
		$content_dir = wp_normalize_path( $content_dir );

		$url = str_replace( $content_dir, $content_url, $file );

		return $url;

	}

	
	/*portfolio Single Shortcode*/
	public function finbuzz_single_portfolio_info() {
		ob_start();
		$finbuzz_portfolio_client_name   	= get_post_meta( get_the_ID(), 'portfolio_client_name', true );
		$finbuzz_portfolio_start_date   = get_post_meta( get_the_ID(), 'portfolio_start_date', true );
		$finbuzz_portfolio_end_date   = get_post_meta( get_the_ID(), 'portfolio_end_date', true );
		$finbuzz_portfolio_website   	= get_post_meta( get_the_ID(), 'portfolio_website', true );
		$finbuzz_term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
		?>

		<?php if ( ( FinbuzzTheme::$options['portfolio_client'] )  && !empty( $finbuzz_portfolio_client_name  ) || ( FinbuzzTheme::$options['portfolio_start_date'] ) && !empty( $finbuzz_portfolio_start_date) || ( FinbuzzTheme::$options['portfolio_end_date'] ) && !empty( $finbuzz_portfolio_end_date) || ( FinbuzzTheme::$options['portfolio_website'] )  && !empty( $finbuzz_portfolio_website) || ( FinbuzzTheme::$options['portfolio_category'] ) && !empty( $finbuzz_term_lists ) ) { ?>
		    <div class="portfoilo-info-wrap">
				<h3 class="info-title"><?php _e('Project Details','finbuzz-core'); ?></h3>
				<ul class="project-list">
					<?php if( FinbuzzTheme::$options['portfolio_client'] && !empty( $finbuzz_portfolio_client_name)) {?>
						<li><?php _e('Client Name:','finbuzz-core'); ?></li>
						<li class="project-details-list"><?php echo esc_html( $finbuzz_portfolio_client_name ); ?></li>
					<?php } ?>
					<?php 
					  $i=1;
					  if($finbuzz_term_lists &&  FinbuzzTheme::$options['portfolio_category']){ ?>
						<li><?php _e('Category:','finbuzz-core'); ?></li>
						<li class="project-details-list">
							<?php foreach ( $finbuzz_term_lists as $term_list ){ 
							$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?>
							<?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?>
							<a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a>
							<?php $i++; } ?>
						
						</li>
					<?php } ?>
					<?php if( FinbuzzTheme::$options['portfolio_start_date'] && !empty( $finbuzz_portfolio_start_date)) {?>
						<li><?php _e('Start Date:','finbuzz-core'); ?></li>
						<li class="project-details-list"><?php echo esc_html( $finbuzz_portfolio_start_date ); ?></li>
					<?php } ?>
					<?php if( FinbuzzTheme::$options['portfolio_end_date'] && !empty( $finbuzz_portfolio_end_date)) {?>
						<li><?php _e('End Date:','finbuzz-core'); ?></li>
						<li class="project-details-list"><?php echo esc_html( $finbuzz_portfolio_end_date ); ?></li>
					<?php } ?>
					<?php if( FinbuzzTheme::$options['portfolio_website'] && !empty( $finbuzz_portfolio_website)) {?>
						<li><?php _e('Website:','finbuzz-core'); ?></li>
						<li class="project-details-list"><a href="<?php echo esc_url( $finbuzz_portfolio_website ); ?>"><?php echo esc_html( $finbuzz_portfolio_website ); ?></a></li>
					<?php } ?>
					<?php if ( ( FinbuzzTheme::$options['post_share'] ) && ( function_exists( 'finbuzz_post_share' ) ) ) { ?>
					<li class="post-share"><span><?php esc_html_e( 'Share :', 'finbuzz-core' );?></span><?php finbuzz_post_share(); ?></li>
				<?php } ?>				
				</ul>
			</div>
		<?php }
		return ob_get_clean();
	}

}

new Finbuzz_Core;