<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Tab extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Tab', 'finbuzz-core' );
		$this->rt_base = 'rt-tab';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label'   => esc_html__( 'Tab Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Our Mission', 'finbuzz-core' ),
                'label_block' => true,
            ]
        );
		$repeater->add_control(
            'content',
            [
                'type' => Controls_Manager::WYSIWYG,
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => esc_html__( 'Fund ipsum dolor sit amet, consectetur adipiscing elitsed do eiusmod lora tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse. ', 'finbuzz-core' ),
            ]
        );
       
        
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'Tab', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Image Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'tab_items',
				'label'   => esc_html__( 'Tab Items', 'finbuzz-core' ),
				'fields'  => $repeater->get_controls(),
				'default' => [
			         ['title' => 'Our Mission', ],
			         ['title' => 'Our Vission', ],
		       ],
               
			),
           
			array(
				'mode' => 'section_end',
			),

			/*Title Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .rtin-insurance-tab .nav-tabs .nav-item a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rtin-insurance-tab .nav-tabs .nav-item a' => 'color: {{VALUE}}',
				),
			),

            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_active_color',
				'label'   => esc_html__( 'Title Active Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rtin-insurance-tab .nav-tabs .nav-item a.active span' => 'color: {{VALUE}}',
				),
			),

			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		$template = 'rt-tab';
		return $this->rt_template( $template, $data );
	}
}