<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Logo_Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Logo Slider and Grid', 'finbuzz-core' );
		$this->rt_base = 'rt-logo-slider';
		$this->rt_translate = array(
			'cols'  => array(
				'1'  => esc_html__( '1 Col', 'finbuzz-core' ),
				'2'  => esc_html__( '2 Col', 'finbuzz-core' ),
				'3'  => esc_html__( '3 Col', 'finbuzz-core' ),
				'4'  => esc_html__( '4 Col', 'finbuzz-core' ),
				'5'  => esc_html__( '5 Col', 'finbuzz-core' ),
				'6'  => esc_html__( '6 Col', 'finbuzz-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'image', [
				'type'  => Controls_Manager::MEDIA,
				'label' => esc_html__( 'Image', 'finbuzz-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'url', [
				'type'  => Controls_Manager::TEXT,
				'label' => esc_html__( 'URL(optional)', 'finbuzz-core' ),
				'label_block' => true,
			]
		);

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Logo Layout', 'finbuzz-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Logo Slider', 'finbuzz-core' ),
					'layout2' => esc_html__( 'Logo Gird', 'finbuzz-core' ),
					
				),
				'default' => 'layout2',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'logos_gray_scale',
				'label'       => esc_html__( 'Logos Gray Scale', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Enable', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Disable', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_opacity',
				'label'       => esc_html__( 'Image Opacity', 'finbuzz-core' ),
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'size_units' => [ '%'],
                'selectors' => [
                    '{{WRAPPER}} .logo-brand .logo-item.has-gray:not(:hover) img' => 'opacity: {{SIZE}}%;',
                ],

			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_width',
				'label'       => esc_html__( 'Image Width', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
					],
				],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .logo-brand .logo-item.has-gray img' => 'max-width: {{SIZE}}px;',
                ],

			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'logos',
				'label'   => esc_html__( 'Add as many logos as you want', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),				
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'finbuzz-core' ),
				'condition'=>array('layout'=>array('layout2'))
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 992px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '3',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: < 768px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '2',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '1',
			),
			array(
				'mode' => 'section_end',
			),

			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
			),
			
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 6,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 4,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 3,
                ],
				
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				
			),
			
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['layout'] ) {
			case 'layout2':
			$template = 'logo-grid';
			break;
			default:
			$template = 'logo-slider';
			$this->rt_load_scripts();
			break;
		}
		return $this->rt_template( $template, $data );
	}
}