<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Country_Location extends Custom_Widget_Base{
    public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Country Location', 'finbuzz-core' );
		$this->rt_base = 'rt-country-location';
		parent::__construct( $data, $args );
	}
    public function rt_fields(){
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'location_icon',
			 [
				'type'  => Controls_Manager::ICONS,
				'label' => esc_html__( 'Icon', 'consalty-core' ),
				'label_block' => true,
                'mode'   =>'responsive',
				'default' => array(
					'value' => 'fas fa-map-marker-alt',
					'library' => 'fa-solid',
				),	
				
			]
		);

        $repeater->add_control(
			'icon_position_left', [
				'type'  => Controls_Manager::SLIDER,
				'label_block' => true,
				'label'   => esc_html__( 'Icon Positon Left', 'consalty-core' ),
                'mode'   =>'responsive',
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' => 0,
				 ],
			]
		);

        $repeater->add_control(
			'icon_position_top', [
				'type'  => Controls_Manager::SLIDER,
				'label_block' => true,
                
				'label'   => esc_html__( 'Icon Positon Top', 'consalty-core' ),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' => 0,
				],
			]
		);

        $fields=array(
            array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'consalty-core' ),
			),
            
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'location_info',
				'label'   => esc_html__( 'Add Country Location', 'consalty-core' ),
				'fields' => $repeater->get_controls(),	
			),
            array(
				'mode' => 'section_end',
			),
        );
        return $fields;
    }
    protected function render() {
        $data = $this->get_settings();
        $template = 'country-location';
        return $this->rt_template( $template, $data );
    }
}