<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size5';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$svg='<svg 
xmlns="http://www.w3.org/2000/svg"
xmlns:xlink="http://www.w3.org/1999/xlink"
width="24px" height="24px">
<path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
</svg>';
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
	'posts_per_page' => $number_of_post,
	'paged'          => $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";
?>
<div class="portfolio-default portfolio-multi-layout-2 portfolio-<?php echo esc_attr( $data['layout'] );?>">
	<div class="row  <?php echo esc_attr( $data['item_space'] ); ?>">	
		<?php $j = $data['delay']; $k = $data['duration'];
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();	
				$id 		= get_the_ID();
				$content 	= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
				$portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );			
				$content = wp_trim_words( $content, $data['excerpt_count'], '' );
				$finbuzz_port_no  = get_post_meta( $id, 'portfolio_serial_num', true );
		?>
		<div class="<?php  echo esc_attr( $col_class ) ?>">
		<div class="rtin-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
			<div class="rtin-figure">
				<a href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
							} else {
								echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
							}
						}
					?>
				</a>
				<div class="rtin-content">
					<?php if($data['port_ser_display']): ?>
						<div class="item-number"><?php echo esc_html( $finbuzz_port_no  ) ;?></div>
					<?php endif; ?>
					<?php if ( $data['cat_display'] ) { ?>
						<?php
							$i = 1;
							$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
							if($term_lists){ ?>
							<div class="cat-list">
								<?php foreach ( $term_lists as $term_list ){ 
								$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
								</div>	
					<?php } }?>
					<h3>
						<a href="<?php echo the_permalink(); ?>">
						<?php echo wp_kses($portfolio_title,'alltext_allow');?>
						</a>
					</h3>
					<?php if ($data['excerpt_display']=='yes' ) { ?>
					  <p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
					<?php } ?>

					<?php if ( $data['view_portfolio_link_btn'] ) { ?>
						<div class="portfolio-btn">
							<a href="<?php the_permalink();?>" class="btn-style2">+ <span><?php esc_html_e('Read More','finbuzz-core'); ?></span></a>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		</div>
		<?php $j = $j + 0.2;  } ?>
	<?php } ?>
	</div>
	<?php if ( $data['more_button_display'] == 'yes' ) : ?>
		<?php if ( $data['more_button'] == 'show' ) { ?>
			<?php if ( !empty( $data['see_button_text'] ) ) { ?>
			<div class="portfolio-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>"><?php echo esc_html( $data['see_button_text'] );?><?php echo wp_kses_post($svg); ?></a></div>
			<?php } ?>
		<?php } else { ?>
			<?php FinbuzzTheme_Helper::pagination(); ?>
		<?php } ?>
	<?php endif; ?>	
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>