<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thum_size='finbuzz-size5';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
    'posts_per_page' => $number_of_post,
    'paged'          => $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$swiper_data = json_encode( $swiper_data );

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

?>

<div class="portfolio-default portfolio-multi-layout-8 portfolio-<?php echo esc_attr( $data['layout'] );?>">
<div class="rt-related-slider" data-xld = '<?php echo esc_attr( $swiper_data )  ;?>'>
     <div class="swiper-wrapper " >	
            <?php 
                if ( $query->have_posts() ) {
                    while ( $query->have_posts() ) {
                    $query->the_post();	
                    $id 		= get_the_ID();
                    $excerpt = wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
                    $portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
                    $finbuzz_port_no  = get_post_meta( $id, 'finbuzz_port_no', true );				      
            ?>
            <div class="swiper-slide">
                <div class="rtin-item">
                    <div class="rtin-figure">
                        <a href="<?php the_permalink(); ?>">
                            <?php
                                if ( has_post_thumbnail() ){
                                    the_post_thumbnail( $thum_size, ['class' => 'img-fluid mb-10 width-100'] );
                                } else {
                                    if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
                                        echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], 'full' );
                                    } else {
                                        echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
                                    }
                                }
                            ?>
                        </a>
                    </div>
                    <div class="rtin-content">
					<h3>
						<a href="<?php the_permalink(); ?>"><span><?php echo wp_kses($portfolio_title,'alltext_allow');?></span></a>
					</h3>
                    <?php if ( $data['cat_display'] == 'yes' ) { ?>
                        <div class="rtin-cat"><?php
                            $i = 1;
                            $term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
                            if($term_lists){
                            foreach ( $term_lists as $term_list ){ 
                            $link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?>
                            </a><?php $i++; } }?>
                        </div>
					<?php } ?>
                    <?php if( $data['view_portfolio_link_btn'] == 'yes'){ ?>
                        <div class="port-btn">
                            <a href="<?php the_permalink();?>" class="read-more-btn"><svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M15 28.1429C22.2586 28.1429 28.1429 22.2586 28.1429 15C28.1429 7.7414 22.2586 1.85714 15 1.85714C7.7414 1.85714 1.85714 7.7414 1.85714 15C1.85714 22.2586 7.7414 28.1429 15 28.1429ZM15 30C23.2843 30 30 23.2843 30 15C30 6.71573 23.2843 0 15 0C6.71573 0 0 6.71573 0 15C0 23.2843 6.71573 30 15 30Z" fill="#828282"/>
                            <path d="M15.7533 21.1746L21.2016 15.5877C21.2841 15.503 21.3427 15.4113 21.3774 15.3126C21.4115 15.2138 21.4286 15.108 21.4286 14.9951C21.4286 14.8822 21.4115 14.7764 21.3774 14.6777C21.3427 14.5789 21.2841 14.4872 21.2016 14.4026L15.7533 8.81561C15.6019 8.66042 15.4129 8.57916 15.1861 8.57182C14.9589 8.56505 14.7627 8.64631 14.5976 8.81561C14.4325 8.97081 14.3463 9.16466 14.3392 9.39716C14.3326 9.63024 14.4118 9.83142 14.5769 10.0007L18.6219 14.1486H9.39693C9.16304 14.1486 8.96684 14.2296 8.80835 14.3916C8.6504 14.5541 8.57143 14.7553 8.57143 14.9951C8.57143 15.235 8.6504 15.4359 8.80835 15.5978C8.96684 15.7604 9.16304 15.8416 9.39693 15.8416H18.6219L14.5769 19.9895C14.4256 20.1447 14.3463 20.3422 14.3392 20.5821C14.3326 20.8219 14.4118 21.0194 14.5769 21.1746C14.7283 21.3439 14.9209 21.4286 15.1548 21.4286C15.3887 21.4286 15.5882 21.3439 15.7533 21.1746Z" fill="#828282"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M14.6998 8.91535C14.8382 8.77343 14.9962 8.70913 15.1817 8.71461C15.3734 8.72085 15.5268 8.78795 15.651 8.91535L21.0993 14.5023C21.1691 14.5739 21.2155 14.6481 21.2425 14.7247C21.2709 14.8072 21.2857 14.897 21.2857 14.9951C21.2857 15.0932 21.2709 15.1831 21.2425 15.2656C21.2155 15.3422 21.1691 15.4163 21.0993 15.4879L15.651 21.0749C15.5124 21.217 15.3497 21.2857 15.1548 21.2857C14.9602 21.2857 14.8068 21.2174 14.6834 21.0794L14.6751 21.0701C14.5417 20.9447 14.4765 20.7878 14.482 20.5861C14.4882 20.378 14.5556 20.216 14.6792 20.0892L18.9607 15.6988H9.39692C9.20023 15.6988 9.04133 15.6321 8.91062 15.4981C8.78037 15.3645 8.71428 15.2002 8.71428 14.9951C8.71428 14.7902 8.7803 14.6255 8.91053 14.4914C9.04119 14.3579 9.20012 14.2915 9.39692 14.2915H18.9607L14.6792 9.90098C14.5407 9.75897 14.4765 9.59512 14.482 9.4014C14.488 9.20572 14.5588 9.04814 14.6954 8.9197L14.6998 8.91535ZM14.4975 8.71366C14.6888 8.5185 14.9224 8.42104 15.1904 8.42902C15.4521 8.43749 15.6771 8.53293 15.8555 8.71587L21.3038 14.3028C21.399 14.4004 21.4698 14.5096 21.5122 14.6304C21.5519 14.7453 21.5714 14.8676 21.5714 14.9951C21.5714 15.1226 21.5521 15.2443 21.5124 15.3592C21.47 15.48 21.399 15.5898 21.3038 15.6874L15.8555 21.2744C15.6639 21.4709 15.4277 21.5714 15.1548 21.5714C14.8837 21.5714 14.6533 21.472 14.4746 21.2744C14.2809 21.0901 14.1888 20.8539 14.1964 20.5781C14.2045 20.3067 14.2956 20.0734 14.4747 19.8898L18.283 15.9845H9.39692C9.12583 15.9845 8.89235 15.8886 8.70607 15.6976C8.52042 15.5072 8.42857 15.2697 8.42857 14.9951C8.42857 14.7205 8.52041 14.4829 8.70589 14.292C8.89222 14.1016 9.12599 14.0058 9.39692 14.0058H18.283L14.4747 10.1005C14.283 9.90392 14.1887 9.66546 14.1964 9.39312C14.2046 9.12491 14.3054 8.89523 14.4975 8.71366Z" fill="#828282"/>
                            </svg>
                        </a>
                        </div>
				    <?php } ?>

				</div>
                </div>
            </div>
            <?php  } ?>
        <?php } ?>
    </div>
    <?php if($data['navigation']=='yes'){ ?>
        <div class="swiper-button">
            <div class="swiper-button-prev"><i class="fa fa-angle-left"></i></div>
            <div class="swiper-button-next"><i class="fa fa-angle-right"></i></div>
        </div>
    <?php } ?>
</div>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>

 