<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

extract($data);

$circle_number=$data['number']['size'] ? $data['number']['size']:'80';
$circle_size=$data['circle_size']['size'] ? $data['circle_size']['size']:'160';
$circle_border_size=$data['circle_border']['size'] ? $data['circle_border']['size']:'8';
$circle_options=array(
	'circle_size' 			=> $circle_size,
	'circle_border_size' 	=> $circle_border_size,
	'animation_speed'  		=>$data['speed']['size'],
	'bg_color'  			=>$data['bgcolor_color'],
	'fg_color'  			=>$data['fgcolor_color']
);

?>
<div class="progress-circle counter-appear">
	<div class="counter-block style-1">
		<div class="chart-bar style-1" data-percent="<?php echo esc_attr( $circle_number ); ?>" data-circle-options="<?php echo esc_attr(json_encode($circle_options) ); ?>">
			<div class="counter-wrap">
				<div class="count-number">
					<span class="counterUp" data-duration="<?php echo esc_attr( $data['duration']['size']); ?>" data-counter="<?php echo esc_attr( $circle_number ); ?>"><?php echo esc_html( $circle_number ); ?></span>%
				</div>
				<?php if($data['title']): ?>
				<div class="title"><?php echo wp_kses_post( $data['title'] ); ?></div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>