<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$svg='<svg 
xmlns="http://www.w3.org/2000/svg"
xmlns:xlink="http://www.w3.org/1999/xlink"
width="24px" height="24px">
<path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
</svg>';
$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
}

//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}


if ( !empty( $data['buttontext'] ) ) {
	$btn = '<a class="btn-style1" ' . $attr . '>' . $data['buttontext'] .$svg.'</a>';
}

//image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'info_bg_image_size', 'info_bg_image' );

$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $icon_class['value'] ) ) {
  $final_icon_image_url = $icon_class['value']['url'];
}

?>
<div class="info-box info-<?php echo esc_attr( $data['style'] );?>">
	<div class="info-item media-<?php echo esc_attr( $data['icontype'] );?>">
		<div class="info-media">
			<?php if ( $getimg) { ?>		            
				<span class="info-img"><?php echo wp_kses_post($getimg);?></span>  
			<?php } ?> 
		</div>
		<div class="info-content">
			<div class="inner-info-content">
				<?php if ( !empty( $data['title'] ) ) { ?>
				<h3 class="info-title"><?php echo wp_kses_post( $title );?></h3>
				<?php } ?>
				<?php  if ( !empty( $data['content'] ) ) { ?>
					<div class="info-text"><?php echo wp_kses_post( $data['content'] ); ?></div>
				<?php } ?>
				<div class="info-button-area">
					<?php if ( $data['button_display']  == 'yes' ) { ?>
						<?php if ( !empty( $btn ) ){ ?>
							<div class="info-button"><?php echo wp_kses_post( $btn );?></div>		
						<?php } } ?>
					<?php if ( !empty( $data['info_number'] ) ) { ?>
						<div class="info-number"><span class="count-number"><?php echo wp_kses_post( $data['info_number'] );?></span></div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</div>



