<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//image
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'rt_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
}
$mask_getimg = wp_get_attachment_image( $data['rt_image2_style7']['id'], 'full');
$percentage_getimg = wp_get_attachment_image( $data['rt_image3_style7']['id'], 'thumbnail');

?>

<div class="image-default image-<?php echo esc_attr( $data['style'] );?> ">
	<div class="image-box rt-animate wow fadeInDown" data-wow-delay=".2s">
		<?php if($data['mask_image_display']){ ?>
			<div class="mask-image  rt-animate wow fadeInDown" data-wow-delay=".8s">
				<?php if($mask_getimg){ ?>
					<?php echo  wp_kses_post($mask_getimg);?>
				<?php } else{ ?>	
					<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/mask-image.svg'; ?>" height="84" width="92" alt="">
				<?php } ?>
			</div>
		<?php } ?>
		<div class="full-image">
			<?php echo wp_kses_post($getimg);?>
		</div>
		<ul class="images-shape d-none d-xl-block">
			<li class="rt-animate wow fadeInUp" data-wow-delay="600ms" data-wow-duration="800ms">
				<?php if($percentage_getimg){ ?>
					<?php echo  wp_kses_post($percentage_getimg);?>
				<?php } else{ ?>	
					<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape18.png'; ?>" height="84" width="92" alt="">
				<?php } ?>
			</li>
			<li class="motion-effects2 red-shape">
				<svg width="129" height="119" viewBox="0 0 129 119" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M125.368 90.3117L126.299 89.136L125.123 88.2045L106.011 73.0631L104.835 72.1317L103.904 73.3074C96.9846 82.0412 86.8794 87.6687 75.8112 88.9518C64.7429 90.235 53.6183 87.0688 44.8845 80.1497C36.1507 73.2307 30.5233 63.1255 29.2401 52.0572C27.9569 40.989 31.1231 29.8644 38.0422 21.1306L38.9737 19.9548L37.7979 19.0234L18.6854 3.882L17.5096 2.95054L16.5781 4.1263C5.14925 18.5527 -0.0806773 36.9283 2.03887 55.2108C4.15843 73.4932 13.4538 90.1849 27.8802 101.614C42.3066 113.043 60.6823 118.273 78.9647 116.153C97.2472 114.034 113.939 104.738 125.368 90.3117Z" fill="#FA360A" stroke="#FA360A" stroke-width="3"/>
				</svg>
	
			</li>
			
			<li class="motion-effects3">
				<?php if($data['shape3_display']){ ?>
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape20.png'; ?>" width="47" height="49" alt="">
				<?php } ?>	
			</li>
			
			<li class="motion-effects5">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape25.png'; ?>" width="173" height="169" alt="">	
			</li>
		</ul>
		
	</div>
</div>